#pragma once

#include "sensor.h"

#include <rtline/library/json/adapters.h>
#include <rtline/library/json/cast_range.h>

#include <rtline/util/types/field.h>
#include <rtline/util/types/range.h>

#include <util/generic/set.h>

namespace NDrive {
    class TSensorFilterCondition {
    public:
        NDrive::TSensorId SensorId;
        TRange<TSeconds> SinceAge;
        TRange<TSeconds> TimestampAge;
        TRange<double> ValueRange;

        DECLARE_FIELDS(
            Field(NJson::CompatibleStringify(SensorId), "sensor"),
            Field(SinceAge, "since_age"),
            Field(TimestampAge, "timestamp_age"),
            Field(ValueRange, "value_range")
        );

    public:
        bool Match(const TSensor& sensor, TInstant now) const;
        bool Match(TConstArrayRef<TSensor> sensors, TInstant now) const;
    };

    class TSensorFilter {
    public:
        enum class EOp {
            And,
            Or,
        };

    public:
        EOp Op = EOp::And;
        TVector<TSensorFilterCondition> Conditions;
        TVector<TSensorFilter> Subfilters;

        DECLARE_FIELDS(
            Field(NJson::Stringify(Op), "op"),
            Field(Conditions, "conditions"),
            Field(Subfilters, "subfilters")
        );

    public:
        explicit operator bool() const {
            return !Conditions.empty() || !Subfilters.empty();
        }

        bool Match(TConstArrayRef<TSensor> sensors, TInstant now) const;

    private:
        bool MatchAnd(TConstArrayRef<TSensor> sensors, TInstant now) const;
        bool MatchOr(TConstArrayRef<TSensor> sensors, TInstant now) const;
    };
}
