#include "types.h"

size_t NDrive::NProtocol::TZeroTerminatedString::CalcSize() const {
    return Value.size() + 1;
}

void NDrive::NProtocol::TZeroTerminatedString::Load(IInputStream* s) {
    char c;
    while (s && s->ReadChar(c)) {
        if (c) {
            Value.push_back(c);
        }
    }
}

void NDrive::NProtocol::TZeroTerminatedString::Save(IOutputStream* s) const {
    if (s) {
        s->Write(Value);
        s->Write('\0');
    }
}

TStringBuf NDrive::NProtocol::TZeroTerminatedString::Get() const {
    return Value;
}

void NDrive::NProtocol::TZeroTerminatedString::Set(TStringBuf value) {
    Value = value;
}
