LIBRARY()

OWNER(svshevtsov)

GENERATE_ENUM_SERIALIZATION(errors.h)
GENERATE_ENUM_SERIALIZATION(navtelecom.h)
GENERATE_ENUM_SERIALIZATION(protocol.h)
GENERATE_ENUM_SERIALIZATION(sensor_filter.h)
GENERATE_ENUM_SERIALIZATION(settings.h)
GENERATE_ENUM_SERIALIZATION(vega.h)
GENERATE_ENUM_SERIALIZATION(wialon.h)

PEERDIR(
    contrib/libs/openssl/crypto
    drive/telematics/protocol/proto
    drive/vega/lib/trunk/vega_libs/serv_protocols_lib
    drive/vega/lib/trunk/vega_libs/tea_crypt
    drive/vega/projects/lib/crc_lib
    library/cpp/charset
    library/cpp/json
    library/cpp/langs
    rtline/library/json
    rtline/util/types
)

SRCS(
    actions.cpp
    calibration.cpp
    crc.cpp
    errors.cpp
    log.cpp
    mio.cpp
    navtelecom.cpp
    nonce.cpp
    poly1305.cpp
    protocol.cpp
    sensor.cpp
    sensor_filter.cpp
    sensor_value.cpp
    settings.cpp
    types.cpp
    vega.cpp
    wialon.cpp
)

END()
