#pragma once

#include <drive/telematics/server/pusher/interface.h>

#include <drive/library/cpp/auth/tvm.h>

#include <util/generic/set.h>

namespace NNeh {
    class THttpClient;
    class THttpReply;
    class THttpRequest;
}

namespace NDrive {
    class TBackendPusherOptions : public IPusherOptions {
    public:
        virtual THolder<IPusher> BuildPusher(const TAtomicSharedPtr<NTvmAuth::TTvmClient>& tvm) const override;
        virtual TSet<NTvmAuth::TTvmId> GetDestinationClientIds() const override;

    private:
        virtual void Init(const TYandexConfig::Section& section) override;
        virtual void Print(IOutputStream& os) const override;

    private:
        static inline TFactory::TRegistrator<TBackendPusherOptions> Registrator{"Backend"};

    public:
        TString Endpoint;
        NTvmAuth::TTvmId DestinationClientId = 0;
        TSet<TSensorId> SensorIds;
    };

    class TBackendPusher: public IPusher {
    public:
        TBackendPusher(const TBackendPusherOptions& options, const TAtomicSharedPtr<NTvmAuth::TTvmClient>& tvm);
        ~TBackendPusher();

        NThreading::TFuture<TPushResult> Push(const TString& imei, const IHandlerDescription& handler, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const THeartbeat& heartbeat, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const TLocation& location, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const TSensor& sensor, TInstant deadline = TInstant::Zero()) override;

    private:
        NNeh::THttpRequest CreateRequest() const;
        NThreading::TFuture<NDrive::IPusher::TPushResult> ProcessResponse(const NThreading::TFuture<NNeh::THttpReply>& reply) const;

    private:
        THolder<NNeh::THttpClient> Client;
        THolder<NDrive::TTvmAuth> TvmAuth;

        const TString Handler;
        const TSet<TSensorId> SensorIds;
    };
}
