#pragma once

#include <drive/telematics/server/data/clickhouse/client.h>
#include <drive/telematics/server/pusher/interface.h>

#include <library/cpp/clickhouse/client/client.h>

#include <util/generic/set.h>

namespace NDrive {
    class TTelematicsClickHousePusherOptions: public IPusherOptions {
    public:
        THolder<IPusher> BuildPusher(const TAtomicSharedPtr<NTvmAuth::TTvmClient>& tvm) const override;

        TSet<NTvmAuth::TTvmId> GetDestinationClientIds() const override {
            return {};
        }

        const TClickHousePusher::TBalancingOptions& GetBalancingOptions() const {
            return BalancingOptions;
        }

        const TVector<NClickHouse::TClientOptions>& GetOptions() const {
            return Options;
        }

    private:
        void Init(const TYandexConfig::Section& section) override;
        void Print(IOutputStream& os) const override;

    private:
        TClickHousePusher::TBalancingOptions BalancingOptions;
        TVector<NClickHouse::TClientOptions> Options;

    private:
        static inline TFactory::TRegistrator<TTelematicsClickHousePusherOptions> Registrator{"ClickHouse"};
    };

    class TTelematicsClickHousePusher: public IPusher {
    public:
        TTelematicsClickHousePusher(const TTelematicsClickHousePusherOptions& options);

        NThreading::TFuture<TPushResult> Push(const TString& imei, const IHandlerDescription& handler, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const THeartbeat& heartbeat, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const TLocation& location, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TPushResult> Push(const TString& imei, const TSensor& sensor, TInstant deadline = TInstant::Zero()) override;

    private:
        TClickHousePusher Pusher;
    };
}
