#include "settings.h"

#include <rtline/util/algorithm/container.h>

NDrive::TTelematicsDynamicSettings::TTelematicsDynamicSettings(TAtomicSharedPtr<NRTLine::IVersionedStorage> storage)
    : IAutoActualization("TelematicsDynamicSettings")
    , Storage(storage)
{
    Refresh();
    Y_ENSURE_BT(Start());
}

NDrive::TTelematicsDynamicSettings::~TTelematicsDynamicSettings() {
    if (!Stop()) {
        ERROR_LOG << "cannot stop TelematicsDynamicSettings" << Endl;
    }
}

TMaybe<TString> NDrive::TTelematicsDynamicSettings::GetValue(const TString& key) const {
    {
        TReadGuard guard(Lock);
        auto p = Values.find(key);
        if (p != Values.end()) {
            return p->second;
        }
    }
    if (Storage) {
        TString value;
        if (!Storage->GetValue(key, value)) {
            return {};
        }
        TWriteGuard guard(Lock);
        Values[key] = value;
        return value;
    }
    return {};
}

bool NDrive::TTelematicsDynamicSettings::Refresh() {
    TVector<TString> keys;
    {
        TReadGuard guard(Lock);
        keys = MakeVector(NContainer::Keys(Values));
    }
    TMap<TString, TString> values;
    if (Storage) {
        for (auto&& key : keys) {
            TString value;
            if (!Storage->GetValue(key, value)) {
                continue;
            }
            values.emplace(key, std::move(value));
        }
    }
    {
        TWriteGuard guard(Lock);
        Values = std::move(values);
    }
    return true;
}
