#pragma once

#include <rtline/library/storage/abstract.h>
#include <rtline/util/auto_actualization.h>

#include <util/generic/map.h>
#include <util/generic/string.h>
#include <util/system/rwlock.h>

namespace NDrive {
    class TTelematicsDynamicSettings final: protected IAutoActualization {
    public:
        TTelematicsDynamicSettings(TAtomicSharedPtr<NRTLine::IVersionedStorage> storage);
        ~TTelematicsDynamicSettings();

        template <class T>
        TMaybe<T> Get(const TString& key) const {
            auto value = GetValue(key);
            if (!value) {
                return {};
            }
            T result;
            if (!TryFromString(*value, result)) {
                ERROR_LOG << "cannot parse " << value << " as " << TypeName<T>() << Endl;
                return {};
            }
            return result;
        }

    protected:
        TMaybe<TString> GetValue(const TString& key) const;

        virtual bool Refresh() override;

    private:
        const TAtomicSharedPtr<NRTLine::IVersionedStorage> Storage;

        mutable TMap<TString, TString> Values;
        TRWMutex Lock;
    };
}
