#include "signals.h"

NDrive::TTelematicsUnistatSignals& NDrive::TTelematicsUnistatSignals::Get() {
    return *Singleton<NDrive::TTelematicsUnistatSignals>();
}

const NUnistat::TIntervals NDrive::TTelematicsUnistatSignals::Intervals = {
    0,
    500,
    1000,
    1500,
    2000,
    3000,
    4000,
    5000,
    10000,
    20000,
};

const TVector<TString> NDrive::TTelematicsUnistatSignals::TelematicsHandlers = { 
    "/connection/command/", 
    "/connection/drop/", 
    "/connection/list/", 
    "/connection/log/", 
    "/connection/ping/", 
    "/connection/locations/", 
    "/connection/sensors/", 
    "/connection/view/", 
    "/task/view/", 
    "/task/wait/", 
};

NDrive::TSensorsPushSignal::TSensorsPushSignal(TString&& signalName)
    : SignalCounter({ std::move(signalName) }, false)
{
}

void NDrive::TSensorsPushSignal::Signal(const double& value) const {
    SignalCounter.Signal(value);
}
