#pragma once

#include <drive/telematics/protocol/vega.h>

#include <rtline/library/unistat/signals.h>

#include <util/string/builder.h>

namespace NDrive {
    class TTelematicsUnistatSignals {
    public:
        static const NUnistat::TIntervals Intervals;
        static const TVector<TString> TelematicsHandlers;

        TUnistatSignal<> BlackboxAges {{ "blackbox-ages" }, Intervals};
        TUnistatSignal<> BytesSent {{ "bytes-sent" }, false};
        TUnistatSignal<> BytesReceived {{ "bytes-received" }, false};
        TUnistatSignal<> ConnectionEstablished {{ "connection-established" }, false};
        TUnistatSignal<> ConnectionExpelled {{ "connection-expelled" }, false};
        TUnistatSignal<> ConnectionRegistered {{ "connection-registered" }, false};
        TUnistatSignal<> ConnectionDeregistered {{ "connection-deregistered" }, false};
        TUnistatSignal<> ConnectionDestroyed {{ "connection-destroyed" }, false};
        TUnistatSignal<> ConnectionDropped {{ "connection-dropped" }, false};
        TUnistatSignal<> ConnectionTotal {{ "connection-total" }, EAggregationType::LastValue, "ammv"};
        TUnistatSignal<> HandlersRegistered {{ "handlers-registered" }, false};
        TUnistatSignal<> HandlersDeregistered {{ "handlers-deregistered" }, false};
        TUnistatSignal<> HandlersHedge {{ "handlers-hedge" }, false};
        TUnistatSignal<> HandlersRetry {{ "handlers-retry" }, false};
        TUnistatSignal<> HandlersTotal {{ "handlers-total" }, EAggregationType::LastValue, "ammv" };
        TUnistatSignal<> MessagesTimes {{ "messages-times" }, Intervals};
        TUnistatSignal<> MessagesErrors {{ "messages-errors" }, false};
        TUnistatSignal<> MessagesOrphans {{ "messages-orphans" }, false};
        TUnistatSignal<> GeocoderRequests {{ "geocoder-requests" }, false};
        TUnistatSignal<> GeocoderTimes {{ "geocoder-times" }, NRTLineHistogramSignals::IntervalsRTLineReply};
        TUnistatSignal<> LBSRequests {{ "lbs-requests" }, false};
        TUnistatSignal<> LBSTimes {{ "lbs-times" }, NRTLineHistogramSignals::IntervalsRTLineReply};
        TUnistatSignal<> LinkerSuccess {{ "linker-success" }, false};
        TUnistatSignal<> LinkerTrackRequestFailed {{ "linker-track_request-failed" }, false};
        TUnistatSignal<> LinkerTrackParsingFailed {{ "linker-track_parsing-failed" }, false};
        TUnistatSignal<> LinkerMatchingFailed {{ "linker-matching-failed" }, false};
        TUnistatSignal<> LinkerMatchingOrProjectingFailed {{ "linker-matching_or_projecting-failed" }, false};
        TUnistatSignal<> LinkerLocatingFailed {{ "linker-locating-failed" }, false};
        TUnistatSignal<> PusherSuccess {{ "pusher-success" }, false};
        TUnistatSignal<> PusherFailure {{ "pusher-failure" }, false};
        TEnumSignal<NVega::EMessageType> IncomingMessages {{ "messages-incoming" }, false };
        TEnumSignal<NVega::EMessageType> OutgoingMessages {{ "messages-outgoing" }, false };
        TEnumSignal<NVega::ECommandCode> CommandTimes {{ "command-times" }, Intervals};
        TEnumSignal<NVega::TCommandResponse::EResult> CommandResults {{ "command-results" }, false};
        TEnumSignal<TString, double, false> ClientTimes { { "client-times" }, TelematicsHandlers, Intervals};
        TEnumSignal<TString, double, false> ClientErrors { { "client-errors" }, TelematicsHandlers, false };
        TUnistatSignal<> BackendPusherSuccess {{ "backend-pusher-success" }, false};
        TUnistatSignal<> BackendPusherFailure {{ "backend-pusher-failure" }, false};
        TUnistatSignal<> BackendPusherException {{ "backend-pusher-exception" }, false};
        TUnistatSignal<> TelematicsCacheApiPusherSuccess {{ "telematics-cache-api-pusher-success" }, false};
        TUnistatSignal<> TelematicsCacheApiPusherFailure {{ "telematics-cache-api-pusher-failure" }, false};
        TUnistatSignal<> TelematicsCacheApiPusherException {{ "telematics-cache-api-pusher-exception" }, false};
        TUnistatSignal<> YAGRPusherSuccess {{ "yagr-pusher-success" }, false};
        TUnistatSignal<> YAGRPusherFailure {{ "yagr-pusher-failure" }, false};
        TUnistatSignal<> YAGRPusherException {{ "yagr-pusher-exception" }, false};
        TUnistatSignal<> SaasPusherSuccess {{ "saas-pusher-success" }, false};
        TUnistatSignal<> SaasPusherFailure {{ "saas-pusher-failure" }, false};
        TUnistatSignal<> SaasPusherException {{ "saas-pusher-exception" }, false};
        TUnistatSignal<> SaasPusherUserError {{ "saas-pusher-user-error" }, false};
        TUnistatSignal<> SaasPusherExceededInFlight {{ "saas-pusher-exceeded-in-flight" }, false};
        TUnistatSignal<> SaasPusherUnknown {{ "saas-pusher-unknown" }, false};

        static TTelematicsUnistatSignals& Get();
        inline static TString GetSensorsPushSignalName(TSensorId sensorId) {
            return TStringBuilder() << "pusher-sensor-" << sensorId.Id << "-request";
        }
    };

    class TSensorsPushSignal: public IContextSignal<double> {
    private:
        TUnistatSignal<double> SignalCounter;

    public:
        TSensorsPushSignal(TString&& signalName);

        void Signal(const double& value) const override;
    };
}
