#pragma once

#include <drive/telematics/server/location/history.h>
#include <drive/telematics/server/sensors/cache.h>

#include <util/system/mutex.h>

namespace NDrive::NProto {
    class TTelematicsHistory;
}

namespace NDrive {
    struct TBlackboxRecord {
        TMaybe<TGpsLocation> Location;
        TVector<TSensor> Sensors;
    };
    struct TBlackboxRecords {
        ui64 Id = 0;
        TVector<TBlackboxRecord> Values;
    };

    class TTelematicsHistory {
    public:
        TTelematicsHistory(TDuration locationDepth = TDuration::Minutes(10), ui32 sensorDepth = 1 << 10)
            : Locations(locationDepth)
            , Sensors(sensorDepth)
        {
        }

        const TLocationHistory& GetLocations() const {
            return Locations;
        }
        const TSensorsCache& GetSensors() const {
            return Sensors;
        }

        TInstant GetTimestamp() const;
        TString DebugString() const;

        void Add(TBlackboxRecord&& record);
        void Add(TBlackboxRecords&& records);
        void Add(TGpsLocation&& location);
        void Add(TMultiSensor&& sensors);
        void Add(TSensor&& sensor);

        TMaybe<TInstant> GetPushed(const TGpsLocation& location) const;
        TMaybe<TInstant> GetPushed(TSensorId sensorId) const;
        void OnPush(const TGpsLocation& location);
        void OnPush(const TSensor& sensor);

        void Serialize(NDrive::NProto::TTelematicsHistory& proto) const;
        void Serialize(TString& value) const;
        bool Deserialize(const NDrive::NProto::TTelematicsHistory& proto);
        bool Deserialize(const TString& value);

        template <class T>
        T Serialize() const {
            T result;
            Serialize(result);
            return result;
        }

    private:
        TLocationHistory Locations;
        TSensorsCache Sensors;

        TMutex PushedLock;
        TMaybe<TInstant> PushedLocation;
        TMap<TSensorId, TInstant> PushedSensors;
    };
    using TTelematicsHistoryPtr = TAtomicSharedPtr<TTelematicsHistory>;
}
