#include "blackbox.h"

#include <drive/telematics/protocol/vega.h>

#include <drive/library/cpp/yt/node/cast.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/yson/node/node_io.h>

Y_UNIT_TEST_SUITE(Blackbox) {
    auto blackboxString = R"(
    {
        "records": [
            {
                "timestamp": 1639770946,
                "subrecords": [
                    {
                        "speed": 0,
                        "lat": 55.73572922,
                        "course": 252,
                        "lon": 37.83775711,
                        "type": "position_data",
                        "sats": 13,
                        "height": 184
                    },
                    {
                        "type": "custom_parameters",
                        "params": {
                            "2": "VEGA MT-32K LTE V2 rc42 'X1' 8073627 850",
                            "300": 17042723,
                            "305": 0,
                            "1044": 0,
                            "1045": 0,
                            "1174": "WBAJG110405N50340",
                            "1175": "null",
                            "1176": 0,
                            "1252": 12.95299149,
                            "1253": 4.177582264,
                            "2103": 82121,
                            "2107": 45,
                            "2108": 329,
                            "2131": 0,
                            "2156": 0,
                            "2157": 0
                        }
                    }
                ],
                "type": "record"
            }
        ],
        "id": 11212
    }
    )";

    Y_UNIT_TEST(Parse) {
        auto records = NYT::FromNode<NDrive::TBlackboxRecords>(NYT::NodeFromJsonString(blackboxString));
        UNIT_ASSERT_VALUES_EQUAL(records.Id, 11212);
        UNIT_ASSERT_VALUES_EQUAL(records.Values.size(), 1);

        auto record = records.Values[0];
        UNIT_ASSERT(record.Location);
        UNIT_ASSERT_VALUES_EQUAL(record.Sensors.size(), 19);

        NDrive::TTelematicsHistory history;
        history.Add(std::move(records));
        auto now = Now();
        auto dtc = history.GetSensors().Get(VEGA_ECM_DTC_LIST_SENSOR, now);
        UNIT_ASSERT(dtc);
        UNIT_ASSERT_VALUES_EQUAL(dtc->ConvertTo<TString>(), "null");
    }
}
