#pragma once

#include <library/cpp/clickhouse/client/block.h>

namespace NClickHouse {
    class TSimpleBlock {
    public:
        operator TBlock() const {
            TBlock result;
            for (auto&& [name, col] : Columns) {
                result.AppendColumn(name, col);
            }
            return result;
        }

        TColumnRef operator[](size_t idx) const {
            return Columns.at(idx).second;
        }

        void AppendColumn(const TString& name, const TColumnRef& col) {
            Columns.emplace_back(name, col);
        }

        size_t GetColumnCount() const {
            return Columns.size();
        }

    private:
        TVector<std::pair<TString, TColumnRef>> Columns;
    };
}
