#pragma once

#include <drive/telematics/server/location/location.h>

namespace NClickHouse {
    class TBlock;
    class TSimpleBlock;
}

namespace NDrive {
    struct TLocationClickHouseCtx;
    struct TLocationClickHouseRecord: public TLocation {
    public:
        TString Imei;
        TString ObjectId;

        TLocationClickHouseRecord() = default;
        TLocationClickHouseRecord(const TLocation& location, const TString& imei, const TString& objectId)
            : TLocation(location)
            , Imei(imei)
            , ObjectId(objectId)
        {
        }
    };
    using TLocationClickHouseRecords = TVector<TLocationClickHouseRecord>;

    struct TLocationHistoryClickHouseCtx;
    struct TLocationHistoryClickHouseRecord: public TGpsLocation {
    public:
        TString Imei;
        TString ObjectId;
        TInstant Received;

        TLocationHistoryClickHouseRecord() = default;
        TLocationHistoryClickHouseRecord(const TGpsLocation& location, const TString& imei, const TString& objectId, TInstant received)
            : TGpsLocation(location)
            , Imei(imei)
            , ObjectId(objectId)
            , Received(received)
        {
        }
    };
    using TLocationHistoryClickHouseRecords = TVector<TLocationHistoryClickHouseRecord>;

    const TString& GetLocationClickHouseTable();
    const TString& GetLocationHistoryClickHouseTable();
}

void Append(NClickHouse::TSimpleBlock& block, const NDrive::TLocationClickHouseRecord& record);
void Append(NClickHouse::TSimpleBlock& block, const NDrive::TLocationClickHouseRecord& record, NDrive::TLocationClickHouseCtx& ctx);
void Append(NClickHouse::TSimpleBlock& block, const NDrive::TLocationHistoryClickHouseRecord& record);
void Append(NClickHouse::TSimpleBlock& block, const NDrive::TLocationHistoryClickHouseRecord& record, NDrive::TLocationHistoryClickHouseCtx& ctx);
void Append(NClickHouse::TSimpleBlock& block, const TString& imei, const TString& objectId, const NDrive::TGpsLocation& sensor, TInstant received);
void Append(NClickHouse::TSimpleBlock& block, const TString& imei, const TString& objectId, const NDrive::TGpsLocation& sensor, TInstant received, NDrive::TLocationHistoryClickHouseCtx& ctx);

void Extract(const NClickHouse::TBlock& block, NDrive::TLocationClickHouseRecords& records);
void Extract(const NClickHouse::TBlock& block, NDrive::TLocationHistoryClickHouseRecords& records);
