#include "block.h"
#include "ctx.h"
#include "location.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(ClickHouseLocation) {
    TString SampleImei = "438480742578576";
    TString SampleObjectId = "d08dfc03-33c6-4e73-861d-67159d48bc9c";

    Y_UNIT_TEST(Columns) {
        NClickHouse::TBlock block;
        NDrive::TLocationHistoryClickHouseCtx ctx;
        NDrive::Initialize(ctx, block);

        UNIT_ASSERT_VALUES_EQUAL(block.GetRowCount(), 0);
        UNIT_ASSERT_VALUES_EQUAL(block.GetColumnCount(), 8);

        NClickHouse::TBlock::TIterator iterator(block);
        UNIT_ASSERT(iterator.IsValid());
        UNIT_ASSERT_VALUES_EQUAL(iterator.Name(), "object_id");
        iterator.Next();
        UNIT_ASSERT(iterator.IsValid());
        UNIT_ASSERT_VALUES_EQUAL(iterator.Name(), "imei");
        iterator.Next();
        UNIT_ASSERT(iterator.IsValid());
        UNIT_ASSERT_VALUES_EQUAL(iterator.Name(), "timestamp");
        iterator.Next();
        UNIT_ASSERT(iterator.IsValid());
        UNIT_ASSERT_VALUES_EQUAL(iterator.Name(), "received");
        iterator.Next();
        UNIT_ASSERT(iterator.IsValid());
        UNIT_ASSERT_VALUES_EQUAL(iterator.Name(), "latitude");
        iterator.Next();
        UNIT_ASSERT(iterator.IsValid());
        UNIT_ASSERT_VALUES_EQUAL(iterator.Name(), "longitude");
        iterator.Next();
        UNIT_ASSERT(iterator.IsValid());
        UNIT_ASSERT_VALUES_EQUAL(iterator.Name(), "course");
        iterator.Next();
        UNIT_ASSERT(iterator.IsValid());
        UNIT_ASSERT_VALUES_EQUAL(iterator.Name(), "speed");
        iterator.Next();
        UNIT_ASSERT(!iterator.IsValid());
    }

    template <class TCtx, class TRecord>
    void TestInputOutput() {
        NClickHouse::TSimpleBlock simpleBlock;
        TCtx ctx;
        TRecord record;
        record.ObjectId = SampleObjectId;
        record.Imei = SampleImei;
        record.Timestamp = TInstant::Seconds(424242);
        record.Latitude = 54;
        record.Longitude = 37;
        Append(simpleBlock, record);

        NClickHouse::TBlock block = simpleBlock;
        UNIT_ASSERT_VALUES_EQUAL(block.GetRowCount(), 1);

        TVector<TRecord> records;
        Extract(block, records);
        UNIT_ASSERT_VALUES_EQUAL(records.size(), 1);
        for (auto&& r : records) {
            UNIT_ASSERT_VALUES_EQUAL(r.ObjectId, record.ObjectId);
            UNIT_ASSERT_VALUES_EQUAL(r.Imei, record.Imei);
            UNIT_ASSERT_VALUES_EQUAL(r.Timestamp, record.Timestamp);
            UNIT_ASSERT_DOUBLES_EQUAL(r.Latitude, record.Latitude, 0.001);
            UNIT_ASSERT_DOUBLES_EQUAL(r.Longitude, record.Longitude, 0.001);
        }
    }

    Y_UNIT_TEST(InputOutput) {
        TestInputOutput<NDrive::TLocationClickHouseCtx, NDrive::TLocationClickHouseRecord>();
    }

    Y_UNIT_TEST(HistoryInputOutput) {
        TestInputOutput<NDrive::TLocationHistoryClickHouseCtx, NDrive::TLocationHistoryClickHouseRecord>();
    }
}
