CREATE TABLE "drive_location_history" ON CLUSTER '{cluster}' (
    "object_id" String,
    "imei" String,
    "received" DateTime,
    "timestamp" DateTime,
    "latitude" Float64,
    "longitude" Float64,
    "course" Float64,
    "speed" UInt32
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/drive_location_history/{uuid}', '{replica}')
ORDER BY ("object_id", "timestamp", "imei")
PARTITION BY (toYYYYMMDD("timestamp"))
TTL "timestamp" + INTERVAL 1 WEEK
;

CREATE TABLE "drive_sensor_history" ON CLUSTER '{cluster}' (
    "object_id" String,
    "imei" String,
    "id" UInt16,
    "subid" UInt16,
    "timestamp" DateTime,
    "value_int" UInt64,
    "value_float" Float64,
    "value_string" String,
    "groupstamp" DateTime,
    "received" DateTime
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/drive_sensor_history/{uuid}', '{replica}')
ORDER BY ("object_id", "id", "subid", "groupstamp", "timestamp", "imei")
PARTITION BY (toYYYYMMDD("timestamp"), "id")
TTL "timestamp" + INTERVAL 1 WEEK
    GROUP BY "object_id", "id", "subid", "groupstamp"
    SET
        imei = argMax(imei, timestamp),
        timestamp = max(timestamp),
        received = argMax(received, timestamp),
        value_int = argMax(value_int, timestamp),
        value_float = argMax(value_float, timestamp),
        value_string = argMax(value_string, timestamp)
;

CREATE TABLE "drive_locations" ON CLUSTER '{cluster}' (
    "imei" String,
    "name" String,
    "latitude" Float64,
    "longitude" Float64,
    "course" Float64,
    "since" DateTime,
    "timestamp" DateTime,
    "object_id" String
)
ENGINE = ReplicatedReplacingMergeTree('/clickhouse/tables/{shard}/drive_locations/{uuid}', '{replica}', timestamp)
ORDER BY ("imei", "name")
;

CREATE TABLE "drive_sensors" ON CLUSTER '{cluster}' (
    "imei" String,
    "id" UInt16,
    "subid" UInt16,
    "value_int" UInt64,
    "value_float" Float64,
    "value_string" String,
    "since" DateTime,
    "timestamp" DateTime,
    "object_id" String
)
ENGINE = ReplicatedReplacingMergeTree('/clickhouse/tables/{shard}/drive_sensors/{uuid}', '{replica}', timestamp)
ORDER BY ("imei", "id", "subid")
PARTITION BY ("id" % 16)
;
