#pragma once

#include <drive/telematics/protocol/sensor.h>

namespace NClickHouse {
    class TBlock;
    class TSimpleBlock;
}

namespace NDrive {
    struct TSensorClickHouseCtx;
    struct TSensorClickHouseRecord: public TSensor {
        TString Imei;
        TString ObjectId;

        TSensorClickHouseRecord() = default;
        TSensorClickHouseRecord(const TSensor& sensor, const TString& imei, const TString& objectId)
            : TSensor(sensor)
            , Imei(imei)
            , ObjectId(objectId)
        {
        }
    };
    using TSensorClickHouseRecords = TVector<TSensorClickHouseRecord>;

    struct TSensorHistoryClickHouseCtx;
    struct TSensorHistoryClickHouseRecord: public TSensor {
        TString Imei;
        TString ObjectId;
        TInstant Groupstamp;
        TInstant Received;

        TSensorHistoryClickHouseRecord() = default;
        TSensorHistoryClickHouseRecord(const TSensor& sensor, const TString& imei, const TString& objectId, TInstant groupstamp, TInstant received)
            : TSensor(sensor)
            , Imei(imei)
            , ObjectId(objectId)
            , Groupstamp(groupstamp)
            , Received(received)
        {
        }
    };
    using TSensorHistoryClickHouseRecords = TVector<TSensorHistoryClickHouseRecord>;

    const TString& GetSensorClickHouseTable();
    const TString& GetSensorHistoryClickHouseTable();
}

void Append(NClickHouse::TSimpleBlock& block, const NDrive::TSensorClickHouseRecord& record);
void Append(NClickHouse::TSimpleBlock& block, const NDrive::TSensorClickHouseRecord& record, NDrive::TSensorClickHouseCtx& ctx);
void Append(NClickHouse::TSimpleBlock& block, const NDrive::TSensorHistoryClickHouseRecord& record);
void Append(NClickHouse::TSimpleBlock& block, const NDrive::TSensorHistoryClickHouseRecord& record, NDrive::TSensorHistoryClickHouseCtx& ctx);

void Extract(const NClickHouse::TBlock& block, NDrive::TSensorClickHouseRecords& records);
void Extract(const NClickHouse::TBlock& block, NDrive::TSensorHistoryClickHouseRecords& records);
