#include "events.h"

#include <rtline/library/json/parse.h>

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::TTelematicsEvent& object) {
    NJson::TJsonValue result;
    NJson::InsertField(result, "location", object.Location);
    NJson::InsertField(result, "timestamp", NJson::Seconds(object.Timestamp));
    NJson::InsertField(result, "type", NJson::Stringify(object.Type));
    return result;
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NDrive::TTelematicsEvent& result) {
    return
        NJson::ParseField(value["location"], result.Location) &&
        NJson::ParseField(value["timestamp"], NJson::Seconds(result.Timestamp)) &&
        NJson::ParseField(value["type"], NJson::Stringify(result.Type));
}
