#pragma once

#include <drive/telematics/server/location/location.h>

#include <drive/telematics/protocol/sensor.h>

namespace NDrive {
    class TTelematicsHistory;

    struct TFeaturesCalculationContext {
        TMaybe<TVector<TGpsLocation>> Locations;
        TMaybe<TGpsLocation> PreviousLocation;
        TMaybe<TSensor> Sensor;
        TMaybe<double> SensorValue;

        TVector<TSensor> BadSensors;
    };

    using TThresholdDurationCounterCalcer = std::function<TMaybe<double>(
        const TGpsLocation& /*location*/,
        const TTelematicsHistory& /*history*/,
        TFeaturesCalculationContext& /*context*/
    )>;
    struct TThresholdDurationCounterOptions {
        TDuration Threshold;
        TMaybe<std::pair<ui32, ui32>> SpeedRange;
        double MinValue = 0;
        bool Debug = false;
        bool Brake = false;
    };
    using TThresholdDurationCounterFactors = TVector<std::pair<TThresholdDurationCounterCalcer, TThresholdDurationCounterOptions>>;

    struct TThresholdDurationCounterResult {
        TVector<std::pair<TInstant, TInstant>> Ranges;
        TVector<std::pair<TInstant, double>> Values;
    };
    TThresholdDurationCounterResult Calc(
        const TThresholdDurationCounterCalcer& calcer,
        const TTelematicsHistory& history,
        const TThresholdDurationCounterOptions& options,
        TFeaturesCalculationContext* context = nullptr
    );

    const TThresholdDurationCounterFactors& GetDefaultThresholdDurationCounterFactors();

    TThresholdDurationCounterCalcer MakeGpsAccelerationCalcer();
    TThresholdDurationCounterCalcer MakeSensorValueCalcer(TSensorId id);
}
