#include <drive/telematics/server/library/connection.h>
#include <drive/telematics/server/library/server.h>
#include <drive/telematics/server/ut/library/helper.h>

namespace {
    class TServer {
    public:
        static auto Instance() {
            return SingletonWithPriority<TServer, 100000000>()->Builder.GetServer().Get();
        }

    public:
        TServer()
            : Builder(0, TString{})
        {
            Builder.GetConfig()->SetProtocolType(NDrive::NProtocol::PT_WIALON_IPS);
            Builder.Run();
        }

    private:
        TTelematicServerBuilder Builder;
    };
}

extern "C" int LLVMFuzzerTestOneInput(const ui8* data, size_t size) {
    auto server = TServer::Instance();
    auto connection = NDrive::TTelematicsConnection::Create(server, nullptr);
    Y_ASSERT(connection);
    connection->Fuzz(data, size);

    return 0;
}
