#include "beacons_refresher.h"

#include "scenarios.h"
#include "server.h"

NDrive::TBeaconsRefresher::TBeaconsRefresher(const NDrive::TTelematicsServer& server, const TString& imei, TInstant now, TDuration interval)
    : TGlobalScheduler::TScheduledItem<TBeaconsRefresher>(server.Name(),
                                    TStringBuilder() << "beacon_refresher:" << imei << ":" << static_cast<const void*>(this), now)
    , Server(server)
    , IMEI(imei)
    , Interval(interval)
{
}

void NDrive::TBeaconsRefresher::Process(void* /*threadSpecificResource*/) {
    auto cleanup = Hold(this);
    auto connection = Server.GetConnection(IMEI);
    if (!connection) {
        return;
    }
    const auto& sensors = connection->GetSensorsCache();
    auto speed = sensors.Get(VEGA_SPEED);
    bool needQueryBeacons = !speed || std::abs(speed->ConvertTo<double>()) < 1e-6;
    if (needQueryBeacons) {
        TCommandOptions options;
        options.Retries = 1;
        auto id = NProtocol::GenerateId(IMEI);
        auto handler = CreateCommand(id, NVega::ECommandCode::SCENARIO_QUERY_BEACONS, {}, options);
        connection->AddHandler(std::move(handler)); // connection may be dead?
    }
}

THolder<TGlobalScheduler::IScheduledItem> NDrive::TBeaconsRefresher::GetNextScheduledItem(TInstant now) const {
    auto connection = Server.GetConnection(IMEI);
    if (!connection || !connection->Alive()) {
        return nullptr;
    }
    return MakeHolder<TBeaconsRefresher>(Server, IMEI, now + Interval, Interval);
}
