#include "cdg.h"

#include "server.h"

#include <drive/telematics/server/common/signals.h>

NDrive::TCoupDeGrace::TCoupDeGrace(const TTelematicsServer& server, TInstant now, TDuration interval)
    : TGlobalScheduler::TScheduledItem<TCoupDeGrace>(server.Name(), "coup_de_grace", now + interval)
    , Server(server)
    , Interval(interval)
{
}

void NDrive::TCoupDeGrace::Process(void* /*threadSpecificResource*/) {
    auto cleanup = Hold(this);
    INFO_LOG << GetId() << " started" << Endl;
    auto connections = Server.GetConnections();
    for (auto&& connection : connections) {
        if (!connection) {
            continue;
        }

        auto heartbeat = connection->GetHeartbeatTime();
        if (heartbeat + Server.GetConfig().GetRigorMortisThreshold() < Now()) {
            INFO_LOG << connection->DebugString() << ": dropping connection due to rigor mortis " << heartbeat << Endl;
            connection->Drop();
            TTelematicsUnistatSignals::Get().ConnectionDropped.Signal(1);
        }
    }
    INFO_LOG << GetId() << " finished" << Endl;
}

THolder<TGlobalScheduler::IScheduledItem> NDrive::TCoupDeGrace::GetNextScheduledItem(TInstant now) const {
    return MakeHolder<TCoupDeGrace>(Server, now, Interval);
}
