#pragma once

#include <drive/library/cpp/searchserver/client.h>

namespace NDrive {
    class TReplyContext: public TCommonHttpReplyContext<TServerRequestData> {
    private:
        using TBase = TCommonHttpReplyContext<TServerRequestData>;

    public:
        using TRequestData = TServerRequestData;
        using TBase::TBase;

        virtual const TCgiParameters& GetCgiParameters() const override {
            return Client->GetRequestData().CgiParam;
        }

        virtual TCgiParameters& MutableCgiParameters() override {
            return Client->MutableRequestData().CgiParam;
        }

        virtual TStringBuf GetUri() const override {
            return Client->GetRequestData().ScriptName();
        }

        virtual TServerRequestData& MutableRequestData() override {
            return Client->MutableRequestData();
        }

        virtual const TServerRequestData& GetRequestData() const override {
            return Client->MutableRequestData();
        }
    };

    class TTelematicsServer;
    class TTelematicsServerHttpClient: public THttpClientImpl<TReplyContext> {
    public:
        TTelematicsServerHttpClient(TTelematicsServer* server)
            : Server(server)
        {
        }

    private:
        virtual IHttpReplier::TPtr DoSelectHandler(IReplyContext::TPtr context) override;

    private:
        TTelematicsServer* Server;
    };
}
