#pragma once

#include <rtline/library/scheduler/global.h>

namespace NDrive {
    class TTelematicsServer;

    class TFastDataScheduler: public TGlobalScheduler::TScheduledItem<TFastDataScheduler> {
    public:
        TFastDataScheduler(const NDrive::TTelematicsServer& server, const TString& imei, TInstant now, TDuration interval);

        virtual void Process(void* /*threadSpecificResource*/) override;
        virtual THolder<IScheduledItem> GetNextScheduledItem(TInstant now) const override;

    private:
        const NDrive::TTelematicsServer& Server;
        const TString IMEI;
        const TDuration Interval;
    };
}
