#pragma once

#include <rtline/library/scheduler/global.h>

namespace NDrive {
    class TTelematicsServer;

    class TLogLoader: public TGlobalScheduler::TScheduledItem<TLogLoader> {
    public:
        TLogLoader(const NDrive::TTelematicsServer* server, const TString& imei, TInstant now, TDuration interval);

        virtual void Process(void* /*threadSpecificResource*/) override;
        virtual THolder<IScheduledItem> GetNextScheduledItem(TInstant now) const override;

        TInstant GetLastTimestamp() const;
        size_t GetStep() const;

    public:
        static TString GetLastTimestampKey(const TString& imei) {
            return "imei:" + imei + ":log_last_timestamp";
        }
        static TString GetStepKey(const TString& imei) {
            return "imei:" + imei + ":log_step";
        }

    private:
        const NDrive::TTelematicsServer* Server;
        const TString IMEI;
        const TDuration Interval;
    };
};
