#pragma once

#include "connection.h"

#include <kernel/searchlog/searchlog.h>

class IReplyContext;
class TServerRequestData;

namespace NJson {
    class TJsonValue;
}

namespace NDrive {
    namespace NVega {
        class TMessage;
    }

    class TCommonDistributedData;
    class TTelematicsConnection;

    class TTelematicsLog: public TSearchLog {
    public:
        enum EEvent {
            Created   /* "created" */,
            Closed    /* "closed" */,
            Incoming  /* "incoming" */,
            Outcoming /* "outcoming" */,
        };
        enum EClientEvent {
            Access   /* "access" */,
            Response /* "response" */,
            ResponseError /* "response_error" */,
        };
        enum EHandlerEvent {
            Registered   /* "handler_registered" */,
            Deregistered /* "handler_deregistered" */,
        };
        enum ETaskEvent {
            Started   /* "task_started" */,
            Finished  /* "task_finished" */,
            Dropped   /* "task_dropped" */,
        };
        enum EMiscEvent {
            Error     /* "error" */,
            Location  /* "location" */,
            LogRecord /* "log_record" */,
            Monitoring /* "monitoring" */,
            Sensors   /* "sensors" */,
            ValidationError /* "validation_error" */,
            Warning   /* "warning" */,
        };

    public:
        using TSearchLog::TSearchLog;

        TTelematicsLog(THolder<TLogBackend> backend);

        static void Log(EEvent event, const TTelematicsConnection* connection);
        static void Log(EEvent event, const TTelematicsConnection* connection, const NProtocol::IMessage& message);
        static void Log(EHandlerEvent event, const TTelematicsConnection* connection, const ITelematicsHandler* handler);
        static void Log(ETaskEvent event, const TTelematicsConnection* connection, const TCommonDistributedData& data);
        static void Log(EMiscEvent event, const TTelematicsConnection* connection, const TString& type, NJson::TJsonValue&& data);

        static void Log(EClientEvent event, const IReplyContext* context, const TString& imei, NJson::TJsonValue&& data);

        static void Log(EEvent event, const TTelematicsConnection* connection, const char* data, size_t size);

    private:
        static void Log(const NJson::TJsonValue& r);
    };
}
