#pragma once

#include <drive/telematics/protocol/navtelecom.h>
#include <drive/telematics/protocol/sensor.h>

#include <util/generic/queue.h>
#include <util/system/mutex.h>

namespace NDrive {
    namespace NVega {
        class TMessage;
    }

    namespace NNavTelecom {
        class TNavTelecomProtocol: public NDrive::NProtocol::IProtocol {
        public:
            TNavTelecomProtocol();
            virtual ~TNavTelecomProtocol() = default;

            void Launch() noexcept override;
            THolder<NProtocol::IMessage> Load(IInputStream& stream) override;
            void Process(const NProtocol::IMessage& message) override;
            void Command(THolder<NProtocol::IMessage>&& message) override;
            void Drop() noexcept override;
            NProtocol::TTaskPtr CreateCommand(const TString& id, NProtocol::ECommandCode command, NProtocol::TArgument argument, const TCommandOptions& options) override;

            NNavTelecom::TBitField GetBitField() const;

        private:
            TMutex DataLock;
            TMutex MessagesQueueLock;
            NNavTelecom::TBitField BitField;
            TQueue<THolder<NProtocol::IPayload>> MessagesQueue;

        private:
            void SetBitField(const NNavTelecom::TBitField& bitField);

            void Process(const NNavTelecom::THandShakeRequest& message);
            void Process(const NNavTelecom::TProtocolSettingRequest& message);
            void Process(const NNavTelecom::TBlackBoxRequest& message);
            void Process(const NNavTelecom::TAdditionalBlackBoxRequest& message);
            void Process(const NNavTelecom::TSingleBlackBoxRequest& message);
            void Process(const NNavTelecom::TAdditionalSingleBlackBoxRequest& message);
            void Process(const NNavTelecom::TOnlineBlackBoxRequest& message);
            void Process(const NNavTelecom::TPing& message);
            void Process(const NNavTelecom::TDigitalOutputCommandAnswer& message);
            void Process(const NNavTelecom::TICCIDAnswer& message);

            void AddCommand(THolder<NProtocol::IPayload> command);
            void CheckCommand(THolder<NProtocol::IPayload> answer = nullptr);
        };
    }
}
