#pragma once

#include <rtline/library/scheduler/global.h>

namespace NDrive {
    class TTelematicsServer;
    class TTelematicsDynamicSettings;
}

namespace NDrive {
    class TPinResetter : public TGlobalScheduler::TScheduledItem<TPinResetter> {
    public:
        TPinResetter(
            const TTelematicsServer& server,
            TAtomicSharedPtr<TTelematicsDynamicSettings> dynamicSettings,
            const TString& imei,
            TInstant now,
            TDuration interval
        );

        virtual void Process(void* /*threadSpecificResource*/) override;
        virtual THolder<IScheduledItem> GetNextScheduledItem(TInstant now) const override;

    public:
        static const TString IMEIWhitelistSettingName;
        static const TString DefaultPin;

    private:
        const NDrive::TTelematicsServer& Server;
        TAtomicSharedPtr<TTelematicsDynamicSettings> DynamicSettings;
        const TString IMEI;
        const TDuration Interval;
    };
}
