#include "pinger.h"

#include "server.h"

#include <drive/telematics/protocol/vega.h>

NDrive::TPinger::TPinger(const NDrive::TTelematicsServer* server, const TString& imei, TInstant now, TDuration interval)
    : TGlobalScheduler::TScheduledItem<TPinger>(server->Name(), "pinger:" + imei, now + interval)
    , Server(server)
    , IMEI(imei)
    , Interval(interval)
{
    CHECK_WITH_LOG(Server);
}

void NDrive::TPinger::Process(void* /*threadSpecificResource*/) {
    THolder<TPinger> cleanup(this);
    Y_ASSERT(Server);
    auto connection = Server->GetConnection(IMEI);
    auto now = Now();
    if (connection && connection->Alive() && (now > connection->GetHeartbeatTime() + Interval)) {
        auto message = MakeHolder<NVega::TMessage>(NDrive::NVega::PING_REQUEST);
        connection->SendMessage(std::move(message));
    }
}

THolder<TGlobalScheduler::IScheduledItem> NDrive::TPinger::GetNextScheduledItem(TInstant now) const {
    Y_ASSERT(Server);
    auto connection = Server->GetConnection(IMEI);
    if (connection && connection->Alive()) {
        return MakeHolder<TPinger>(Server, IMEI, now, Interval);
    } else {
        return nullptr;
    }
}
