#include "protocol.h"

#include "navtelecom.h"
#include "wialon.h"

#include <library/cpp/logger/global/global.h>

TVector<NDrive::NProtocol::EProtocolType> NDrive::NProtocol::TProtocolMeta::ProtocolTypes = {
    NDrive::NProtocol::PT_WIALON_IPS,
    NDrive::NProtocol::PT_NAVTELECOM,
};

NDrive::NProtocol::EProtocolType NDrive::NProtocol::TProtocolMeta::TryDetect(const TBuffer& buffer) {
    Y_UNUSED(buffer);
    for (auto protocolType : ProtocolTypes) try {
        auto protocol = CreateProtocol(protocolType);
        if (!protocol) {
            continue;
        }

        TMemoryInput stream(buffer.Data(), buffer.Size());
        auto message = protocol->Load(stream);

        if (message && message->IsValid()) {
            return protocolType;
        }
    } catch (const std::exception& e) {
        ERROR_LOG << GetName() << ": unexpected error " << ToString(protocolType) << " " << FormatExc(e) << Endl;
    }

    return PT_INVALID;
}

THolder<NDrive::NProtocol::IProtocol> NDrive::NProtocol::TProtocolMeta::CreateProtocol(EProtocolType protocolType) {
    IProtocol::TSendHandler dummySender = [] (const IMessage&) { };

    switch (protocolType) {
    case PT_WIALON_IPS:
        return IProtocol::Create<NDrive::NWialon::TWialonProtocol>(std::move(dummySender));
    case PT_NAVTELECOM:
        return IProtocol::Create<NDrive::NNavTelecom::TNavTelecomProtocol>(std::move(dummySender));
    default:
        return nullptr;
    };
}
