#pragma once

#include <drive/telematics/protocol/protocol.h>

namespace NDrive {
    namespace NProtocol {
        class TProtocolMeta {
        public:
            TProtocolMeta() = delete;

            static EProtocolType TryDetect(const TBuffer& buffer);
            static TString GetName() {
                return "Protocol Meta";
            }

        private:
            static TVector<NDrive::NProtocol::EProtocolType> ProtocolTypes;

        private:
            static THolder<IProtocol> CreateProtocol(EProtocolType protocolType);
        };
    }
}
