#pragma once

#include "config.h"

#include <drive/telematics/protocol/sensor.h>
#include <drive/telematics/protocol/vega.h>

#include <rtline/library/scheduler/global.h>

namespace NDrive {
    class TTelematicsServer;

    class TSensorsRefresher: public TGlobalScheduler::TScheduledItem<TSensorsRefresher> {
    public:
        TSensorsRefresher(const NDrive::TTelematicsServer* server, const TString& imei, TInstant now, TDuration interval, const TSensorsDict& sensors = Default<TSensorsDict>());

        virtual void Process(void* /*threadSpecificResource*/) override;
        virtual THolder<IScheduledItem> GetNextScheduledItem(TInstant now) const override;

    private:
        const NDrive::TTelematicsServer* Server;
        const TString IMEI;
        const TDuration Interval;
        TSensorsDict Sensors;
    };
}
