#pragma once

#include <drive/telematics/server/tasks/lite.h>

namespace NDrive {
    class TTelematicsServer;
    class TTelematicsConnection;
    using TTelematicsConnectionPtr = TIntrusivePtr<TTelematicsConnection>;

    class ITelematicsServerContext: public IDistributedTaskContext {
    public:
        virtual TTelematicsServer& GetServer() const = 0;
    };

    class TBaseDistributedTask: public IDistributedTask {
    public:
        using IDistributedTask::IDistributedTask;

    protected:
        virtual bool DoExecute(IDistributedTask::TPtr self) noexcept override;

        virtual bool DoExecuteImpl(IDistributedTask::TPtr self, IDDataStorage::TGuard::TPtr d, TTelematicsConnectionPtr connection) = 0;
    };

    class TPingDistributedTask: public TPingDistributedTaskBase<TBaseDistributedTask> {
    public:
        using TPingDistributedTaskBase::TPingDistributedTaskBase;

    protected:
        virtual bool DoExecuteImpl(IDistributedTask::TPtr self, IDDataStorage::TGuard::TPtr d, TTelematicsConnectionPtr connection) override;
    };

    class TSendCommandDistributedTask: public TSendCommandDistributedTaskBase<TBaseDistributedTask> {
    public:
        using TSendCommandDistributedTaskBase::TSendCommandDistributedTaskBase;

    protected:
        virtual bool DoExecuteImpl(IDistributedTask::TPtr self, IDDataStorage::TGuard::TPtr d, TTelematicsConnectionPtr connection) override;
    };

    class TDownloadFileDistributedTask : public TDownloadFileDistributedTaskBase<TBaseDistributedTask> {
    public:
        using TDownloadFileDistributedTaskBase::TDownloadFileDistributedTaskBase;

    protected:
        virtual bool DoExecuteImpl(IDistributedTask::TPtr self, IDDataStorage::TGuard::TPtr d, TTelematicsConnectionPtr connection) override;
    };

    class TUploadFileDistributedTask: public TUploadFileDistributedTaskBase<TBaseDistributedTask> {
    public:
        using TUploadFileDistributedTaskBase::TUploadFileDistributedTaskBase;

    protected:
        virtual bool DoExecuteImpl(IDistributedTask::TPtr self, IDDataStorage::TGuard::TPtr d, TTelematicsConnectionPtr connection) override;
    };

    class TInterfaceCommunicationDistributedTask : public TInterfaceCommunicationDistributedTaskBase<TBaseDistributedTask> {
    public:
        using TInterfaceCommunicationDistributedTaskBase::TInterfaceCommunicationDistributedTaskBase;

    protected:
        virtual bool DoExecuteImpl(IDistributedTask::TPtr self, IDDataStorage::TGuard::TPtr d, TTelematicsConnectionPtr connection) override;
    };

    class TCanRequestDistributedTask: public TCanRequestDistributedTaskBase<TBaseDistributedTask> {
    public:
        using TCanRequestDistributedTaskBase::TCanRequestDistributedTaskBase;

    protected:
        virtual bool DoExecuteImpl(IDistributedTask::TPtr self, IDDataStorage::TGuard::TPtr d, TTelematicsConnectionPtr connection) override;
    };
}
