#pragma once

#include <library/cpp/threading/future/future.h>

#include <util/generic/map.h>
#include <util/system/rwlock.h>

namespace NThreading {
    template <class T, class TId = TString>
    class TWaiters {
    public:
        template <class TKey>
        TFuture<T> Get(TKey&& id) const {
            {
                TReadGuard guard(Lock);
                auto p = Promises.find(id);
                if (p != Promises.end()) {
                    return p->second.GetFuture();
                }
            }
            auto promise = NewPromise<T>();
            {
                TWriteGuard guard(Lock);
                auto p = Promises.find(id);
                if (p == Promises.end()) {
                    p = Promises.emplace(std::forward<TKey>(id), std::move(promise)).first;
                }
                return p->second.GetFuture();
            }
        }

        template <class TKey>
        void Set(TKey&& id, T&& value) {
            TWriteGuard guard(Lock);
            auto p = Promises.find(id);
            if (p != Promises.end()) {
                p->second.SetValue(std::move(value));
                Promises.erase(p);
            }
        }

    private:
        mutable TMap<TId, TPromise<T>> Promises;
        TRWMutex Lock;
    };
}
