#pragma once

#include <util/generic/ptr.h>

template <class T>
class TWeakAtomicRefCount {
public:
    inline void DecRef() noexcept {
        Y_VERIFY(Counter.Dec() >= 0);
    }
    inline void Ref() noexcept {
        Y_VERIFY(Counter.Inc() > 0);
    }
    inline bool TryWeakRef() noexcept {
        return Counter.TryWeakInc();
    }
    inline void UnRef() noexcept {
        auto resultCount = Counter.Dec();
        Y_VERIFY(resultCount >= 0);
        if (resultCount == 0) {
            TDelete::Destroy(static_cast<T*>(this));
        }
    }

    inline intptr_t RefCount() const noexcept {
        return Counter.Val();
    }

private:
    TAtomicCounter Counter;
};

template <class T>
class TWeakIntrusivePtr: public TIntrusivePtr<T> {
public:
    TWeakIntrusivePtr(T* t = nullptr)
        : TIntrusivePtr<T>(t && t->TryWeakRef() ? t : nullptr)
    {
        T* p = TIntrusivePtr<T>::Get();
        if (p) {
            Y_VERIFY(p->RefCount() >= 2);
            p->DecRef();
        }
    }
};

template <class T>
TWeakIntrusivePtr<T> MakeWeakIntrusive(T* t) {
    return t;
}
