#pragma once

#include <drive/telematics/protocol/wialon.h>

#include <util/system/mutex.h>

namespace NDrive {
    class TTelematicsServer;
    namespace NWialon {
        class TWialonProtocol: public NDrive::NProtocol::IProtocol {
        public:
            using TTelematicsServerPtr = TTelematicsServer*;

            TWialonProtocol(TTelematicsServerPtr server = nullptr);
            virtual ~TWialonProtocol() = default;

            void Launch() noexcept override;
            THolder<NProtocol::IMessage> Load(IInputStream& stream) override;
            void Process(const NProtocol::IMessage& message) override;
            void Drop() noexcept override;
            NProtocol::TTaskPtr CreateCommand(const TString& id, NProtocol::ECommandCode command, NProtocol::TArgument argument, const TCommandOptions& options) override;

        private:
            TString IMEI;
            TMutex Mutex;
            TTelematicsServerPtr Server;

        private:
            inline static const TString IMEISearchName = "beacon_searcher:imei_search";

        private:
            void SetIMEI(const TString& imei);
            const TString& GetIMEI() const;
            bool EnableSearch() const;
            bool EnableSearchFromList() const;

        private:
            void Process(const NWialon::TLoginRequest& message);
            void Process(const NWialon::TPingRequest& message);
            void Process(const NWialon::TShortDataRequest& message);
            void Process(const NWialon::TDataRequest& message);
            void Process(const NWialon::TBlackBoxRequest& message);
        };
    }
}
