#include "cache.h"

void NDrive::TLocationCache::AddLocation(const TLocation& location) {
    auto lock = Guard(Lock);
    Locations[location.Name] = location;
}

TMaybe<NDrive::TLocation> NDrive::TLocationCache::GetLocation(TStringBuf name) const {
    auto lock = Guard(Lock);
    auto p = Locations.find(name);
    if (p != Locations.end()) {
        return p->second;
    } else {
        return {};
    }
}

TVector<NDrive::TLocation> NDrive::TLocationCache::GetLocations() const {
    TVector<NDrive::TLocation> result;
    result.reserve(2 * Locations.size());
    {
        auto lock = Guard(Lock);
        for (auto&&[name, location] : Locations) {
            result.push_back(location);
        }
    }
    return result;
}
