#pragma once

#include "location.h"

#include <util/generic/map.h>
#include <util/generic/maybe.h>
#include <util/system/spinlock.h>

namespace NDrive {
    class TLocationCache {
    public:
        void AddLocation(const TLocation& location);
        TMaybe<TLocation> GetLocation(TStringBuf name) const;
        TVector<TLocation> GetLocations() const;

    private:
        TMap<TString, TLocation> Locations;

        TAdaptiveLock Lock;
    };
    using TLocationCacheConstPtr = TAtomicSharedPtr<const TLocationCache>;
    using TLocationCachePtr = TAtomicSharedPtr<TLocationCache>;
}
