#include "heartbeat.h"

#include <drive/telematics/server/location/proto/heartbeat.pb.h>

#include <rtline/library/json/parse.h>

NDrive::NProto::THeartbeat NDrive::THeartbeat::ToProto() const {
    NDrive::NProto::THeartbeat result;

    result.SetTimestamp(Timestamp.Seconds());
    result.SetCreated(Created.Seconds());
    if (Name) {
        result.SetName(Name);
    }
    if (Host) {
        result.SetHost(Host);
    }
    return result;
}

bool NDrive::THeartbeat::FromProto(const NDrive::NProto::THeartbeat& proto) {
    Timestamp = TInstant::Seconds(proto.GetTimestamp());
    Created = TInstant::Seconds(proto.GetCreated());
    Name = proto.GetName();
    Host = proto.GetHost();
    return true;
}

template <>
NJson::TJsonValue NJson::ToJson<NDrive::THeartbeat>(const NDrive::THeartbeat& object) {
    NJson::TJsonValue result;
    result["timestamp"] = NJson::ToJson(object.Timestamp);
    result["created"] = NJson::ToJson(object.Created);
    result["host"] = object.Host;
    if (object.Name) {
        result["name"] = object.Name;
    }
    return result;
}

template <>
bool NJson::TryFromJson<NDrive::THeartbeat>(const NJson::TJsonValue& value, NDrive::THeartbeat& result) {
    return
        ParseField(value["timestamp"], result.Timestamp, true) &&
        ParseField(value["created"], result.Created) &&
        ParseField(value["name"], result.Name) &&
        ParseField(value["host"], result.Host);
}
