#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NDrive::NProto {
    class THeartbeat;
}

namespace NDrive {
    struct THeartbeat {
        TInstant Timestamp;
        TInstant Created;
        TString Host;
        TString Name;

        THeartbeat() = default;
        THeartbeat(TInstant timestamp, const TString& host = {})
            : Timestamp(timestamp)
            , Host(host)
        {
        }

        explicit operator bool() const {
            return Timestamp || Host;
        }

        NDrive::NProto::THeartbeat ToProto() const;
        bool FromProto(const NDrive::NProto::THeartbeat& proto);
    };

    const TString DefaultHeartbeatName = {};
    const TString ConfiguratorHeartbeatName = "configurator";
}
