#pragma once

#include "location.h"

#include <util/system/rwlock.h>

#include <deque>

namespace NDrive::NProto {
    class TLocationHistory;
}

namespace NDrive {
    class TLocationHistory {
    public:
        TLocationHistory(TDuration depth)
            : Depth(depth)
        {
        }

        size_t GetCount() const;
        TInstant GetTimestamp() const;
        TMaybe<TGpsLocation> GetValueAt(TInstant timestamp, bool skipZeros = true) const;
        TVector<TGpsLocation> GetValues() const;

        void Add(const TGpsLocation& location);

        void Serialize(NDrive::NProto::TLocationHistory& proto) const;
        bool Deserialize(const NDrive::NProto::TLocationHistory& proto);

    private:
        const TDuration Depth;
        std::deque<TGpsLocation> Locations;

        TRWMutex Lock;
    };
}
