#pragma once

#include "common.h"
#include "interface.h"

namespace NDrive {
    class TTelematicsMetadataClient
        : public ITelematicsMetadataClient
        , public TCommonMetadataClient
    {
    public:
        TTelematicsMetadataClient(const NRTLine::TNehSearchClient& client, const TOptions& options = Default<TOptions>())
            : TCommonMetadataClient(client, options)
        {
        }

        virtual NThreading::TFuture<TMaybe<THandler>> GetHandler(const TString& id) const override;
        virtual NThreading::TFuture<THandlers> GetActiveHandlers(const TString& imei) const override;

    private:
        void FillHandlers(const NRTLine::TSearchReply& reply, THandlers& handlers) const;

        NRTLine::TQuery MakeQuery() const;
    };
}
