#include "common.h"

#include <util/string/vector.h>

NThreading::TFuture<NRTLine::TSearchReply> NDrive::TCommonMetadataClient::HeavyQuery(const TString& key, const TString& keyName, NRTLine::TQuery&& query) const {
    query.SetReqClass(Options.ReqClass);
    query.AddPron("timestamp=" + ToString(Now().MicroSeconds()));
    if (keyName) {
        query.AddExtraParam("key_name", keyName);
        query.SetNumDoc(Max<ui16>());
    }
    query.SetText(key);
    return Client.SendAsyncQueryF(query, Options.HeavyTimeout);
}

TVector<NThreading::TFuture<NRTLine::TSearchReply>> NDrive::TCommonMetadataClient::Query(TVector<TString>&& keys, NRTLine::TQuery&& query, TMaybe<ui32> maxKeysPerQueryExt) const {
    auto maxKeysPerQuery = maxKeysPerQueryExt.GetOrElse(Options.MaxKeysPerQuery);
    auto count = std::min<size_t>(maxKeysPerQuery, keys.size() / std::ceil(1.0 * keys.size() / maxKeysPerQuery) + 1);

    TVector<NThreading::TFuture<NRTLine::TSearchReply>> result;
    query.SetReqClass(Options.ReqClass);
    query.AddPron("timestamp=" + ToString(Now().MicroSeconds()));
    for (size_t i = 0; i < keys.size(); i += count) {
        auto begin = keys.begin() + i;
        auto end = std::min(keys.end(), begin + count);
        query.ClearReqId();
        query.SetText(JoinStrings(begin, end, ","));
        result.push_back(Client.SendAsyncQueryF(query, Options.Timeout));
    }
    return result;
}
