#pragma once

#include <rtline/api/search_client/neh_client.h>

namespace NDrive {
    class TCommonMetadataClient {
    public:
        struct TOptions {
            TString ReqClass = "METADATA";
            TDuration Timeout = TDuration::MilliSeconds(500);
            TDuration HeavyTimeout = TDuration::Seconds(2);
            size_t MaxKeysPerQuery = 512;
        };

    protected:
        TCommonMetadataClient(const NRTLine::TNehSearchClient& client, const TOptions& options = Default<TOptions>())
            : Client(client)
            , Options(options)
        {
        }

        NThreading::TFuture<NRTLine::TSearchReply> HeavyQuery(const TString& key, const TString& keyName, NRTLine::TQuery&& query) const;
        TVector<NThreading::TFuture<NRTLine::TSearchReply>> Query(TVector<TString>&& keys, NRTLine::TQuery&& query, TMaybe<ui32> maxKeysPerQueryExt = {}) const;

    protected:
        const NRTLine::TNehSearchClient& Client;
        TOptions Options;
    };
}
