#pragma once

#include <library/cpp/json/json_value.h>
#include <library/cpp/threading/future/future.h>

namespace NDrive {
    class ITelematicsMetadataClient {
    public:
        struct THandler {
            NJson::TJsonValue Data;
            TString Id;
            TString IMEI;
            TInstant Timestamp;
            bool Finished = false;
        };
        using THandlers = TVector<THandler>;

    public:
        virtual ~ITelematicsMetadataClient() = default;

        virtual NThreading::TFuture<TMaybe<THandler>> GetHandler(const TString& id) const = 0;
        virtual NThreading::TFuture<THandlers> GetActiveHandlers(const TString& imei) const = 0;
    };
}
