#include "local.h"

#include <library/cpp/logger/global/global.h>

NThreading::TFuture<TMaybe<NDrive::ITelematicsMetadataClient::THandler>> TLocalMetadataClient::GetHandler(const TString& id) const {
    CHECK_WITH_LOG(LocalSensorStorage);
    auto handler = LocalSensorStorage->GetHandler(id);
    if (!handler) {
        return NThreading::MakeFuture<TMaybe<THandler>>();
    }
    THandler result;
    result.Id = handler->Id;
    result.IMEI = handler->IMEI;
    result.Data = handler->Data;
    result.Finished = handler->Finished;
    result.Timestamp = handler->Timestamp;
    return NThreading::MakeFuture(MakeMaybe(std::move(result)));
}

NThreading::TFuture<NDrive::ITelematicsMetadataClient::THandlers> TLocalMetadataClient::GetActiveHandlers(const TString& imei) const {
    CHECK_WITH_LOG(LocalSensorStorage);
    auto handlers = LocalSensorStorage->GetHandlers(imei);
    auto result = THandlers();
    for (auto&& handler : handlers) {
        if (handler.Finished) {
            continue;
        }
        THandler r;
        r.Id = handler.Id;
        r.IMEI = handler.IMEI;
        r.Data = handler.Data;
        r.Finished = handler.Finished;
        r.Timestamp = handler.Timestamp;
        result.push_back(std::move(r));
    }
    return NThreading::MakeFuture(std::move(result));
}
