#pragma once

#include "interface.h"

#include <drive/telematics/server/pusher/local.h>

class TLocalMetadataClient: public NDrive::ITelematicsMetadataClient {
public:
    TLocalMetadataClient(TLocalSensorStorage::TPtr localSensorStorage)
        : LocalSensorStorage(localSensorStorage)
    {
    }
    TLocalMetadataClient()
        : TLocalMetadataClient(TLocalSensorStorage::Instance())
    {
    }

    virtual NThreading::TFuture<TMaybe<THandler>> GetHandler(const TString& id) const override;
    virtual NThreading::TFuture<THandlers> GetActiveHandlers(const TString& imei) const override;

private:
    TLocalSensorStorage::TPtr LocalSensorStorage;
};
