#include "common.h"

namespace NDrive {
    TString GetHeartbeatKey(TStringBuf name) {
        TStringBuilder result;
        result << "heartbeat";
        if (name) {
            result << ':' << name;
        }
        return result;
    }

    TString GetLocationKey(TStringBuf name) {
        TString result = "location";
        if (name) {
            result.append(':');
            result.append(name);
        }
        return result;
    }

    TString GetSensorKey(TSensorId id) {
        return TStringBuilder() << id.Id << ":" <<id.SubId;
    }

    TString GetHandlerUrl(TStringBuf id) {
        return TStringBuilder() << "handler:" << id;
    }

    TString GetHeartbeatUrl(const TString& imei, TStringBuf name) {
        return TStringBuilder() << "imei:" << imei << ":" << GetHeartbeatKey(name);
    }

    TString GetLocationUrl(const TString& imei, TStringBuf name) {
        return TStringBuilder() << "imei:" << imei << ":" << GetLocationKey(name);
    }

    TString GetSensorUrl(const TString& imei, TSensorId id) {
        return TStringBuilder() << "imei:" << imei << ":" << GetSensorKey(id);
    }
}
