#pragma once

#include <drive/telematics/protocol/sensor.h>

#include <util/generic/string.h>
#include <util/string/builder.h>
#include <util/string/cast.h>

namespace NDrive {
    TString GetHeartbeatKey(TStringBuf name);
    TString GetLocationKey(TStringBuf name);
    TString GetSensorKey(TSensorId id);
    TString GetHandlerUrl(TStringBuf id);
    TString GetHeartbeatUrl(const TString& imei, TStringBuf name);
    TString GetLocationUrl(const TString& imei, TStringBuf name);
    TString GetSensorUrl(const TString& imei, TSensorId id);
}
