#pragma once

#include "interface.h"

#include <drive/library/cpp/threading/future.h>

#include <rtline/util/types/accessor.h>

namespace NDrive {
    class TMetaPusherOptions : public IPusherOptions {
    public:
        virtual THolder<IPusher> BuildPusher(const TAtomicSharedPtr<NTvmAuth::TTvmClient>& tvm) const override;
        virtual TSet<NTvmAuth::TTvmId> GetDestinationClientIds() const override;

    private:
        virtual void Init(const TYandexConfig::Section& section) override;
        virtual void Print(IOutputStream& os) const override;

    public:
        R_FIELD(TVector<THolder<IPusherOptions>>, PushersOptions);
    };

    class TMetaPusher
        : public IPusher {
    public:
        TMetaPusher(const TMetaPusherOptions& options, const TAtomicSharedPtr<NTvmAuth::TTvmClient>& tvm);
        TMetaPusher& AddPusher(THolder<IPusher>&& pusher);

        virtual NThreading::TFuture<TPushResult> Push(const TString& imei, const IHandlerDescription& handler, TInstant deadline = TInstant::Zero()) override;
        virtual NThreading::TFuture<TPushResult> Push(const TString& imei, const THeartbeat& heartbeat, TInstant deadline = TInstant::Zero()) override;
        virtual NThreading::TFuture<TPushResult> Push(const TString& imei, const TLocation& location, TInstant deadline = TInstant::Zero()) override;
        virtual NThreading::TFuture<TPushResult> Push(const TString& imei, const TSensor& sensor, TInstant deadline = TInstant::Zero()) override;

        NThreading::TFuture<TBulkPushResult> BulkPush(const TString& imei, const TConstArrayRef<TTelematicsHandlerPtr> handlersPtrs, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TBulkPushResult> BulkPush(const TString& imei, const TConstArrayRef<THeartbeat> heartbeats, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TBulkPushResult> BulkPush(const TString& imei, const TConstArrayRef<TLocation> locations, TInstant deadline = TInstant::Zero()) override;
        NThreading::TFuture<TBulkPushResult> BulkPush(const TString& imei, const TConstArrayRef<TSensor> sensors, TInstant deadline = TInstant::Zero()) override;

    private:
        template <typename TValue>
        NThreading::TFuture<TPushResult> PushGeneric(const TString& imei, const TValue& value, TInstant deadline);
        template <typename TValue>
        NThreading::TFuture<TBulkPushResult> BulkPushGeneric(const TString& imei, const TConstArrayRef<TValue> values, TInstant deadline);

    private:
        TVector<THolder<IPusher>> Pushers;
    };
}
