#pragma once

#include <drive/telematics/server/pusher/interface.h>

#include <library/cpp/yconf/conf.h>

#include <rtline/util/types/accessor.h>

#include <saas/library/persqueue/writer/shards_info.h>
#include <saas/library/persqueue/writer/writer.h>

namespace NSaas {
    class TPersQueueWriter;
}

namespace NDrive {

    class TSaasPusherOptions : public IPusherOptions {
    public:
        void Init(const TYandexConfig::Section& section) override;
        virtual THolder<IPusher> BuildPusher(const TAtomicSharedPtr<NTvmAuth::TTvmClient>& tvm) const override;
        virtual void Print(IOutputStream& os) const override;
        virtual TSet<NTvmAuth::TTvmId> GetDestinationClientIds() const override;

    private:
        static inline TFactory::TRegistrator<TSaasPusherOptions> Registrator{"SaasPusher"};

    public:
        R_FIELD(TString, ServiceName);
        R_FIELD(ui32, TvmSourceId, 0);
        R_FIELD(TString, TvmToken);
        R_FIELD(TString, TvmFile);
        R_FIELD(ui32, TvmDestinationId, 0);
        R_FIELD(ui32, ThreadsCount, 1);
        R_FIELD(bool, ThreadsBlockingMode, true);
        R_FIELD(ui32, MaxAttempts, 3);
        R_FIELD(TDuration, ConnectionTimeout, TDuration::Seconds(30));
        R_FIELD(TDuration, SendTimeout, TDuration::Seconds(30));
        R_FIELD(ui64, MaxInFlightCount, 0);
        R_FIELD(bool, NoWriteQueue, false);
        R_FIELD(TString, Host, "logbroker.yandex.net");
        R_OPTIONAL(NPersQueueCommon::ECodec, Codec);
        R_FIELD(NSaas::TSearchMapInputSettings, SearchMapInputSettings);
    };

    class TSaasPusher
        : public IPusher {
    public:
        TSaasPusher(const TSaasPusherOptions& options);
        ~TSaasPusher();
        virtual NThreading::TFuture<TPushResult> Push(const TString& imei, const IHandlerDescription& handler, TInstant deadline = TInstant::Zero()) override;
        virtual NThreading::TFuture<TPushResult> Push(const TString& imei, const THeartbeat& heartbeat, TInstant deadline = TInstant::Zero()) override;
        virtual NThreading::TFuture<TPushResult> Push(const TString& imei, const TLocation& location, TInstant deadline = TInstant::Zero()) override;
        virtual NThreading::TFuture<TPushResult> Push(const TString& imei, const TSensor& sensor, TInstant deadline = TInstant::Zero()) override;

    private:
        static NSaas::TAction CreateAction(const TString& imei, const TLocation& location, TInstant deadline = TInstant::Zero());
        NThreading::TFuture<TPushResult> Push(const NSaas::TAction& action);

    public:
        static constexpr ui64 HandlerKeyPrefix = 1;

    private:
        THolder<NSaas::TPersQueueWriter> Writer;
        TDuration HandlerLifetime = TDuration::Days(1);
    };
}
